package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
@EqualsAndHashCode(callSuper = false)
@Data
public class StaffChangeLogVo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;

    private Long id;
    private Long cid;

    @ApiModelProperty("操作账号id")
    private Long userId;

    @ApiModelProperty("操作账号")
    private String username;

    @ApiModelProperty("被编辑数据id")
    private Long dataId;

    @ApiModelProperty("操作类型（insert、update、delete）")
    private String tableName;

    @ApiModelProperty("表名")
    private String operation;

    @ApiModelProperty("字段名称中文")
    private String fieldName;

    @ApiModelProperty("字段名称en")
    private String fieldValue;

    @ApiModelProperty("修改前字段值")
    private String beforeValue;

    @ApiModelProperty("修改后字段值")
    private String afterValue;

    @ApiModelProperty("修改前字段值(翻译)")
    private String beforeTranslateValue;

    @ApiModelProperty("修改后字段值(翻译)")
    private String afterTranslateValue;

    @ApiModelProperty("修改内容")
    private String content;

    @ApiModelProperty("修改时间")
    private LocalDateTime editTime;

    @ApiModelProperty("编辑批次编码（用于标记那些字段是一起编辑的）")
    private Long batchCode;

    @ApiModelProperty("data_id对应名称")
    @TableField(exist = false)
    private String dataName;

    public String getBeforeTranslateValue() {
        return this.beforeTranslateValue == null ? beforeValue : beforeTranslateValue;
    }

    public String getAfterTranslateValue() {
        return this.afterTranslateValue == null ? afterValue : afterTranslateValue;

    }
}
