package cn.smarthse.rho.modules.sys.model.c.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * <p>
 * 人员档案统计vo
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="人员档案统计vo", description="人员档案统计vo")
public class StaffArchiveStatisticsCMVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("人员基础信息id")
    private Long id;

    @ApiModelProperty("人员id")
    private Long staffId;

    @ApiModelProperty(value = "单位id")
    private Long cid;

    @ApiModelProperty(value = "所在医院")
    private String companyName;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "岗位/工种")
    private Long post;

    @ApiModelProperty(value = "岗位/工种名称")
    private String postName;

    @ApiModelProperty(value = "岗位状态")
    private Integer postStatus;

    @ApiModelProperty(value = "放射人员工作类型")
    private Integer staffType;

    @ApiModelProperty("本年度个人剂量监测记录")
    private Integer currentYearDoseCheckNum;


    @ApiModelProperty(value = "预警状态：放射证书（0正常 23:无证书-红色预警 24:无证书-启动执法）")
    private Integer certWarning;

    @ApiModelProperty(value = "预警状态：体检（0:正常 11:已体检-首次预警 12:已体检-黄色预警 13:已体检-红色预警 14:已体检-启动执法 23:未体检-红色预警 24:未体检-启动执法）")
    private Integer healthWarning;

    @ApiModelProperty(value = "预警状态：个人剂量（0:正常 11:已监测-首次预警 12:已监测-黄色预警 13:已监测-红色预警 14:已监测-启动执法 23:未监测-红色预警 24:未监测-启动执法）")
    private Integer doseWarning;

    @ApiModelProperty(value = "预警状态：超剂量（0:未超剂量 11:超调查剂量-已调查 12:超调查剂量-未进行）")
    private Integer bigDoseWarning;

    @ApiModelProperty(value = "预警状态：超剂量（0:未超剂量 11:超年度剂量-已调查 12:超年度剂量-未进行）")
    private Integer bigYearDoseWarning;

    @ApiModelProperty(value = "预警状态：放射防护培训（0:正常 11:已培训-首次预警 12:已培训-黄色预警 13:已培训-红色预警 14:已培训-启动执法 23:未培训-红色预警 24:未培训-启动执法）")
    private Integer trainingWarning;

    @ApiModelProperty(value = "培训时间")
    private LocalDateTime trainingTime;

    @ApiModelProperty(value = "体检时间")
    private LocalDateTime physicalExaminationTime;




}
