package cn.smarthse.rho.modules.sys.model.c.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;


/**
 * <p>
 * 人员档案统计vo
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="人员档案统计vo", description="人员档案统计vo")
public class StaffArchiveStatisticsAdminVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("人员基础信息id")
    private Long id;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    @ApiModelProperty(value = "是否有预警：放射证书")
    private Integer hasCertWarning;

    @ApiModelProperty(value = "是否有预警：体检")
    private Integer hasHealthWarning;

    @ApiModelProperty(value = "是否有预警：个人剂量")
    private Integer hasDoseWarning;

    @ApiModelProperty(value = "是否有预警：超剂量")
    private Integer hasBigDoseWarning;

    @ApiModelProperty(value = "是否有预警：年度超剂量")
    private Integer hasBigYearDoseWarning;

    @ApiModelProperty(value = "是否有预警：放射防护培训")
    private Integer hasTrainingWarning;




}
