package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.core.framework.utils.RhoIdCardUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 人员档案列表vo
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "人员档案列表vo", description = "人员档案列表vo")
public class StaffArchiveListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("人员基础信息id")
    private Long id;

    @ApiModelProperty("人员id")
    private Long staffId;

    @ApiModelProperty(value = "单位id")
    private Long cid;

    @ApiModelProperty(value = "手机号")
    //@EncryptField(algorithm = AlgorithmType.AES)
    private String phone;

    @ApiModelProperty(value = "所在医院")
    private String companyName;

    @ApiModelProperty(value = "所在医院类别（1总院 2分院）")
    private Integer companyType;

    @ApiModelProperty(value = "总医院")
    private String mainCompanyId;

    @ApiModelProperty(value = "分医院")
    private String branchCompanyId;

    @ApiModelProperty(value = "总医院")
    private String mainCompanyName;

    @ApiModelProperty(value = "分医院")
    private String branchCompanyName;

    @ApiModelProperty(value = "所在医院")
    private String hospitalName;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "工号")
    private String workNo;

    @ApiModelProperty(value = "身份证")
    private String idcard;

    @ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    @ApiModelProperty(value = "出生日期")
    private LocalDate birthday;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "岗位/工种")
    private Long post;

    @ApiModelProperty(value = "岗位/工种名称")
    private String postName;

    @ApiModelProperty(value = "岗位状态")
    private Integer postStatus;

    @ApiModelProperty(value = "人员类型（0非放射工作人员 1放射工作人员）")
    private Integer staffType;

    @ApiModelProperty(value = "是否是管理员")
    private Integer ifRaManager;

    @ApiModelProperty(value = "管理人员岗位状态（0离岗 1在岗）")
    private Integer managerPostStatus;

    @ApiModelProperty(value = "上岗时间")
    private LocalDateTime postStartTime;

    @ApiModelProperty(value = "离岗未时间")
    private LocalDateTime postDepartureTime;

    @ApiModelProperty(value = "时间阈值")
    private LocalDateTime thresholdTime;

//    @ApiModelProperty(value = "转岗未时间")
//    private LocalDateTime postTransferTime;
//
//    @ApiModelProperty(value = "岗位变更时间")
//    private LocalDateTime postChangeTime;

    @ApiModelProperty(value = "证书文件id")
    private String raCertFileId;

    @ApiModelProperty(value = "放射人员工作证编码")
    private String raCert;

    @ApiModelProperty(value = "放射人员工作证链接")
    private String raCertUrl;

    @ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    @ApiModelProperty(value = "头像id")
    private Long headId;

    @ApiModelProperty(value = "头像")
    private String headFileName;

    @ApiModelProperty(value = "头像")
    private String headFileUrl;

    @ApiModelProperty(value = "体检时间")
    private LocalDateTime healCheckDate;
    @ApiModelProperty(value = "个人剂量检查时间")
    private LocalDateTime doseCheckDate;
    @ApiModelProperty(value = "培训时间")
    private LocalDateTime trainingCheckDate;

    @ApiModelProperty(value = "预警状态：放射证书（0正常 23:无证书-红色预警 24:无证书-启动执法）")
    @TableField("cert_warning")
    private Integer certWarning;

    @ApiModelProperty(value = "预警状态：体检（0:正常 11:已体检-首次预警 12:已体检-黄色预警 13:已体检-红色预警 14:已体检-启动执法 23:未体检-红色预警 24:未体检-启动执法）")
    @TableField("health_warning")
    private Integer healthWarning;

    @ApiModelProperty(value = "预警状态：个人剂量（0:正常 11:已监测-首次预警 12:已监测-黄色预警 13:已监测-红色预警 14:已监测-启动执法 23:未监测-红色预警 24:未监测-启动执法）")
    @TableField("dose_warning")
    private Integer doseWarning;

    @ApiModelProperty(value = "预警状态：超剂量（0:未超剂量 11:超调查剂量-已调查 12:超调查剂量-未进行）")
    @TableField("big_dose_warning")
    private Integer bigDoseWarning;

    @ApiModelProperty(value = "预警状态：超剂量（0:未超剂量 11:超年度剂量-已调查 12:超年度剂量-未进行）")
    @TableField("big_year_dose_warning")
    private Integer bigYearDoseWarning;

    @ApiModelProperty(value = "预警状态：放射防护培训（0:正常 11:已培训-首次预警 12:已培训-黄色预警 13:已培训-红色预警 14:已培训-启动执法 23:未培训-红色预警 24:未培训-启动执法）")
    @TableField("training_warning")
    private Integer trainingWarning;

    @ApiModelProperty(value = "取接条件情况")
    private CertConditionVo certConditionVo;

    @ApiModelProperty(value = "更新时间", hidden = true)
    private LocalDateTime editTime;

    @ApiModelProperty(value = "数据来源（1同步 2单位新增）")
    private Integer source;

    @ApiModelProperty(value = "是否关联数据（0否 1是）:如果有关联体检数据就无法编辑身份证、职业照射代码")
    private Integer hasRelatedData;

//    @ApiModelProperty(value = "是否有体检数据（0否 1是）")
//    private Integer hasHealCheckData;

    public void genSex() {
        if (sex == null && IdcardUtil.isValidCard(idcard)) {
            this.sex = IdcardUtil.getGenderByIdCard(idcard);
        }
    }

    public void genAge() {
        if (age == null && IdcardUtil.isValidCard(idcard)) {
            this.age = IdcardUtil.getAgeByIdCard(idcard);
        }
    }

    public void genIdcard() {
        this.idcard = RhoIdCardUtil.desensitizeIdCard(idcard);
    }

    public void genPhone() {
        this.phone = DesensitizedUtil.mobilePhone(phone);
    }
}
