package cn.smarthse.rho.modules.sys.model.c.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * <p>
 * 放射卫生防护管理人员列表
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="放射卫生防护管理人员列表", description="放射卫生防护管理人员列表")
public class RayStaffListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "人员id")
    private Long staffId;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "管理人员岗位状态（0离岗 1在岗）")
    private Integer managerPostStatus;

    @ApiModelProperty(value = "岗位状态")
    private String postStatus;

    @ApiModelProperty(value = "数据来源（1同步 2单位新增）")
    private Integer dataSource;

    @ApiModelProperty(value = "人员类型（0非放射工作人员 1放射工作人员）")
    private Integer staffType;

    @ApiModelProperty(value = "证书是否有效（0无效 1有效）")
    private Integer certValid;

    @ApiModelProperty(value = "时间阈值")
    private LocalDateTime thresholdTime;



}
