package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.core.framework.utils.RhoIdCardUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * <p>
 * 组织机构-人员列表
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="组织机构-人员列表vo", description="组织机构-人员列表vo")
public class OrgStaffListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("人员基础信息id）")
    private Long id;

    @ApiModelProperty("人员id）")
    private Long staffId;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "工号")
    private String workNo;

    @ApiModelProperty(value = "工号")
    private String idcard;

    @ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "岗位/工种")
    private String post;

    @ApiModelProperty(value = "岗位/工种")
    private String postName;

    public void genSex() {
        if(sex == null && IdcardUtil.isValidCard(idcard)){
            this.sex =  IdcardUtil.getGenderByIdCard(idcard);
        }
    }

    public void genAge() {
        if(age == null && IdcardUtil.isValidCard(idcard)){
            this.age =  IdcardUtil.getAgeByIdCard(idcard);
        }
    }
    public void genIdcard() {
        this.idcard =  RhoIdCardUtil.desensitizeIdCard(idcard);
    }


}
