package cn.smarthse.rho.modules.sys.model.c.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;


/**
 * <p>
 * 医院：放射诊疗许可证Vo
 * </p>
 *
 * @author chenliang
 * @since 2024-03-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="放射工作人员工作证要求vo", description="放射工作人员工作证要求vo")
public class CertConditionVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long staffBaseInfoId;

    @ApiModelProperty("0无；1有")
    private Integer profilePictureInfo;

    @ApiModelProperty("-1缺少有效期内数据 0适任性结论不为【可从事放射工作】【在一定限制条件下可从事放射工作】 1资料完整")
    private Integer healthCheckInfo;

    @ApiModelProperty("职业健康体检结果")
    private String healthCheckResult;

    @ApiModelProperty("-1缺少有效期内数据；0不合格；1合格")
    private Integer trainingInfo;

    @ApiModelProperty("资料：0不完整，1完整")
    private Integer isComplete;
    public Integer getIsComplete() {
        return isComplete != null ? isComplete : profilePictureInfo == 1 && healthCheckInfo == 1 && trainingInfo == 1 ? 1 : 0;
    }
}
