package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：工作经历
 * </p>
 *
 * @author chenliang
 * @since 2024-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_staff_work_experience")
@ApiModel(value="CStaffWorkExperienceVo对象", description="员工：工作经历")
public class CStaffWorkExperienceVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "单位id")
    private Long cid;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "单位名称")
    private String companyName;

    @ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "c_staff.id 员工id")
    private Long staffId;

    @ApiModelProperty(value = "c_staff_base_info.id 员工id")
    private Long staffBaseInfoId;

    @ApiModelProperty(value = "工作经历类型：0离岗 1上岗 2转岗")
    private Integer type;

    @ApiModelProperty(value = "岗位/工种")
    private Long post;

    @ApiModelProperty(value = "岗位/工种")
    private String postName;

    @ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    @ApiModelProperty(value = "上岗时间")
    private LocalDateTime postStartTime;

    @ApiModelProperty(value = "离岗时间")
    private LocalDateTime postDepartureTime;

    @ApiModelProperty(value = "暂时离岗时间")
    private LocalDateTime tpPostDepartureTime;

    @ApiModelProperty(value = "暂时离岗时间")
    private LocalDateTime prePostStartTime;

    @ApiModelProperty(value = "转岗时间")
    private LocalDateTime postTransferTime;
}
