package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：放射卫生培训新增 参数
 * </p>
 *
 * @author chenliang
 * @since 2024-06-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TrainingCertEditParam extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "是否存草稿，默认为true")
    private Boolean ifDraft = true;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty("关键因素画像审核id")
    private Long keyFactorAuditId;

    @ApiModelProperty(value = "员工id")
    private Long staffId;

    @ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    @ApiModelProperty(value = "姓名")
    // @NotNull
    private String staffName;
    @ApiModelProperty(value = "身份证")
    // @NotNull
    private String idcard;

    @ApiModelProperty(value = "医院id", hidden = true)
    private Long cid;
    @ApiModelProperty(value = "医院名称", hidden = true)
    private String compName;
    @ApiModelProperty(value = "医院地址", hidden = true)
    private String companyFullAddress;

    @ApiModelProperty(value = "机构id", hidden = true)
    private Long techId;

    @ApiModelProperty(value = "机构名称")
    private String techName;

    @ApiModelProperty(value = "证书类型：1-放射卫生防护管理人员培训证； 2-放射工作人员防护培训合格证")
    // @NotNull
    private Integer certType;

    @ApiModelProperty(value = "证书编号")
    // @NotNull
    private String certNo;

    // @NotNull
    @ApiModelProperty(value = "取证日期")
    private LocalDate issuanceDate;

    @ApiModelProperty(value = "证书有效期")
    // @NotNull
    private LocalDate certValidDate;

    @ApiModelProperty(value = "培训名称")
    private String trainingName;

    @ApiModelProperty(value = "培训开始时间")
    private LocalDate trainingBeginDate;

    @ApiModelProperty(value = "培训结束时间")
    private LocalDate trainingEndDate;

    @ApiModelProperty(value = "培训类型：1-初训；2-复训")
    // @NotNull()
    private String trainingType;

    @ApiModelProperty(value = "考核结果（0不合格，1合格）")
    private Integer result;

    @ApiModelProperty(value = "培训内容")
    private String trainingContent;

    @ApiModelProperty(value = "培训学时")
    private String trainingHours;

    @ApiModelProperty(value = "附件id")
    // @NotNull
    private Long certFileId;

    @ApiModelProperty(value = "附件url")
    private String certFileUrl;

    @ApiModelProperty(value = "附件名称")
    private String certFileName;

}
