package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 员工：基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="CStaff分页参数", description="员工列表分页参数")
public class StaffPageParam extends PageParam implements Serializable{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("基础信息组织架构id")
    private Long orgId;

    @ApiModelProperty("院区id")
    private List<Long> cidList;

    @ApiModelProperty("取证情况：0无， 1有")
    private Integer certificateStatus;

    @ApiModelProperty("岗位状态：0离岗， 1在岗")
    private Integer postStatus;

    @ApiModelProperty("个人剂量（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）")
    private Integer doseWarning;

    @ApiModelProperty("体检（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）")
    private Integer healthWarning;

    @ApiModelProperty("放射防护培训（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）")
    private Integer trainingWarning;

    @ApiModelProperty("超剂量（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）")
    private Integer bigDoseWarning;

    @ApiModelProperty("仅显示本辖区内各院区数据（null 0：否；1：是）")
    private Integer isOnlyJurisdiction;
}
