package cn.smarthse.rho.modules.sys.model.c.param;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 员工：基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="CStaff分页参数", description="员工列表分页参数")
public class StaffCmPageParam extends PageParam implements Serializable{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("基础信息组织架构id")
    private Long orgId;

    @ApiModelProperty("院区id")
    private List<Long> cidList;
    private String cidListStr;

    @ApiModelProperty("岗位id")
    private Long post;

    @ApiModelProperty("岗位状态：0离岗， 1在岗")
    private Integer postStatus;

    @ApiModelProperty("职业照射种类及代码")
    private String raType;

    @ApiModelProperty("0已取证 20:无证书 23:无证书-红色预警 24:无证书-启动执法")
    private Integer certificateStatus;

    @ApiModelProperty("体检状态（0:已体检-正常 10:已体检 20:未体检 11:已体检-首次预警 12:已体检-黄色预警 13:已体检-红色预警 14:已体检-启动执法 23:未体检-红色预警 24:未体检-启动执法）")
    private Integer physicalExaminationStatus;

    @ApiModelProperty("放射防护培训状态（0:已培训-正常 10:已培训 20:未培训 11:已培训-首次预警 12:已培训-黄色预警 13:已培训-红色预警 14:已培训-启动执法 23:未培训-红色预警 24:未培训-启动执法）")
    private Integer trainingStatus;

    @ApiModelProperty("个人剂量（0:正常 10:已监测 20未监测 11:已监测-首次预警 12:已监测-黄色预警 13:已监测-红色预警 14:已监测-启动执法 23:未监测-红色预警 24:未监测-启动执法）")
    private Integer doseStatus;

    @ApiModelProperty("超调查剂量（0:未超剂量 10：超剂量 11:超调查剂量-已调查 12:超调查剂量-未进行）")
    private Integer bigDoseStatus;

    @ApiModelProperty("超年度调查剂量（0:未超剂量 10：超剂量 11:超年度剂量-已调查 12:超年度剂量-未进行）")
    private Integer yearDoseStatus;

    @ApiModelProperty("是否是职业禁忌证")
    private Integer ifOccContraindication;
    @ApiModelProperty("是否是职业病患者")
    private Integer ifOccDisease;
    @ApiModelProperty("是否是疑是职业病患者")
    private Integer ifOccDiseasePossible;
    @ApiModelProperty("是否是放射卫生防护管理人员")
    private Integer ifRaManager;
    @ApiModelProperty("人员类型（0非放射工作人员 1放射工作人员）")
    private Integer staffType;

    public List<Long> getCidList() {
        if(CollUtil.isEmpty(cidList) && StrUtil.isNotEmpty(cidListStr)){
            List<String> split = StrUtil.split(cidListStr, ",");
            if(CollUtil.isEmpty(split)){
                return null;
            }else {
                return split.stream().map(v->Long.valueOf(cidListStr)).collect(Collectors.toList());
            }
        }else {
            return cidList;
        }
    }
}
