package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 员工：基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="CStaff分页参数", description="员工列表分页参数")
public class StaffChooseListPageParam extends PageParam implements Serializable{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("院区id")
    private List<Long> cidList;

    @ApiModelProperty("是否是放射卫生防护管理人员")
    private Integer ifRaManager;
}
