package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 员工：基础信息编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="员工：基础信息编辑参数（岗位编辑）", description="员工：基础信息编辑参数（岗位编辑）")
public class PostEditParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司id")
    private Long cid;

    @ApiModelProperty(value = "基础信息id")
    private Long cStaffBaseId;

    @ApiModelProperty(value = "c_staff表id")
    private Long cStaffId;

    @ApiModelProperty(value = "岗位/工种(中间表)")
    private String post;

    @ApiModelProperty(value = "岗位状态(中间表)")
    private String postStatus;
}
