package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "证书分页查询参数", description = "员工：证书分页查询参数")
public class CTrainingCertPageParam extends PageParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("人员id")
    private Long staffId;

    @ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    @ApiModelProperty("证书类型：1-放射卫生防护管理人员培训证；2-放射防护培训合格证")
    private Integer certType;

    @ApiModelProperty("显示所有区域数据(null或0：否 1：是)")
    private Integer showAllInfo;

    @ApiModelProperty("是否有效(全部数据null，0：否 1：是)")
    private Integer isEffective;

    @ApiModelProperty("培训数据原id")
    private Long sourceTrainingId;

    @ApiModelProperty("审核状态（只用于手动提交的证书）")
    private Integer auditStatus;

    @ApiModelProperty(value = "是否只展示历史数据 0:否 ，null 1:是", hidden = true)
    private Integer onlyHistoryStaffInfo;

    @ApiModelProperty(value = "离岗时间", hidden = true)
    private LocalDateTime newestPostDepartureTime;

}
