package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.PageParam;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：工作经历编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_staff_work_experience")
@ApiModel(value="CStaffWorkExperience编辑参数", description="员工：工作经历编辑参数")
public class CStaffWorkExperiencePageParam extends PageParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("人员id")
    private Long staffId;

    @ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    @ApiModelProperty("显示所有区域数据(null或0：否 1：是)")
    private Integer showAllInfo;

}
