package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.UserEditParam;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：工作经历编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("c_staff_work_experience")
@ApiModel(value="CStaffWorkExperience编辑参数", description="员工：工作经历编辑参数")
public class CStaffWorkExperienceEditParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "单位id")
    private Long cid;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "c_staff.id")
    private Long staffId;

    @ApiModelProperty(value = "c_staff_base_info.id")
    private Long staffBaseInfoId;

    @ApiModelProperty(value = "工作经历类型：0离岗 1上岗 2转岗")
    private Integer type;

    @ApiModelProperty(value = "岗位/工种")
    private Long post;

    @ApiModelProperty(value = "岗位状态（0离岗 1在岗）")
    private Integer postStatus;

    @ApiModelProperty(value = "岗位/工种")
    private String postName;

    @ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    @ApiModelProperty(value = "上岗时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime postStartTime;

    @ApiModelProperty(value = "离岗时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime postDepartureTime;
}
