package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.UserEditParam;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：单位相关信息编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="员工：单位相关信息编辑参数", description="员工：单位相关信息编辑参数")
public class CStaffEditParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "staffId")
    private Long id;

    @ApiModelProperty(value = "人员基础信息id")
    private Long baseId;

    @ApiModelProperty(value = "公司id")
    private Long cid;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "工作经历类型：0离岗 1上岗 2转岗 3暂时离岗 ")
    private Integer type;

    @ApiModelProperty(value = "岗位/工种")
    private Long post;

    @ApiModelProperty(value = "岗位状态（0离岗 1在岗）")
    private Integer postStatus;

    @ApiModelProperty(value = "工号")
    private String workNo;

    @ApiModelProperty(value = "是否是放射卫生防护管理人员")
    private Integer ifRaManager;

    @ApiModelProperty(value = "管理人员岗位状态（0离岗 1在岗）")
    private Integer managerPostStatus;

    @ApiModelProperty(value = "人员类型（0非放射工作人员 1放射工作人员）")
    private Integer staffType;

    @ApiModelProperty(value = "上岗时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime postStartTime;

    @ApiModelProperty(value = "离岗时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime postDepartureTime;

    @ApiModelProperty(value = "预上岗时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime prePostStartTime;

    @ApiModelProperty(value = "暂时离岗时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime tpPostDepartureTime;

    @ApiModelProperty(value = "数据来源（1同步 2单位新增）")
    private Integer source;


//    public LocalDateTime getTpPostDepartureTime() {
//        return tpPostDepartureTime == null ? tpDepartureTime : tpPostDepartureTime;
//    }
}
