package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.UserEditParam;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：基础信息编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
//@ApiModel(value="员工：基础信息编辑参数", description="员工：基础信息编辑参数")
public class CStaffBaseInfoEditParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty(value = "员工基础信息id")
    private Long id;

    //@ApiModelProperty(value = "姓名")
    private String name;

    //@ApiModelProperty(value = "手机号")
    private String phone;

    //@ApiModelProperty(value = "身份证")
    private String idcard;

    //@ApiModelProperty(value = "年龄")
    private Integer age;

    //@ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    //@ApiModelProperty(value = "出生日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate birthday;

    //@ApiModelProperty(value = "放射人员工作证编码")
    private String raCert;

    //@ApiModelProperty(value = "放射人员工作证链接")
    private String raCertUrl;

    //@ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    //@ApiModelProperty(value = "头像id")
    private Long headId;

    //@ApiModelProperty(value = "数据来源")
    private Integer source;

    //@ApiModelProperty(value = "成为放射人员时间")
    private LocalDate rayStaffTime;

    //@ApiModelProperty(value = "员工公司中间数据")
    private CStaffEditParam staffEditParam;


}
