package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 职业健康体检 参数对象
 *
 * @author wuxq
 * @since 2024-04-10
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class CHealthCheckQueryParam extends PageParam {

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("主表id（baseId）")
    private Long baseId;

    @ApiModelProperty("人员id")
    private Long staffId;

    @ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    @ApiModelProperty("体检类型（1-岗前；2-在岗；3-离岗；4-应急；）")
    private Integer checkType;

    @ApiModelProperty("年份")
    private Integer year;

    @ApiModelProperty("结果包括疑似职业病（true-勾选包含；不勾选不传）")
    private Boolean hasSuspectedDisease;

    @ApiModelProperty("结果包括职业禁忌证（true-勾选包含；不勾选不传）")
    private Boolean hasContraindication;

    @ApiModelProperty("是否包括复查（true-勾选包含；不勾选不传）")
    private Boolean hasRecheck;

    @ApiModelProperty("显示所有区域数据(null或0：否 1：是)")
    private Integer showAllInfo;

    @ApiModelProperty(value = "是否只展示历史数据 0:否 ，null 1:是")
    private Integer onlyHistoryStaffInfo;

    @ApiModelProperty(value = "离岗时间")
    private LocalDateTime newestPostDepartureTime;



}
