package cn.smarthse.rho.modules.sys.model.b.vo.license;

import cn.smarthse.rho.modules.sys.enums.license.LicenseChangeTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChangeLicenseStatisticsVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("全部量")
    private Integer totalNum;
    @ApiModelProperty("基本信息量")
    private Integer baseInfoNum;
    @ApiModelProperty("场所量")
    private Integer placeNum;
    @ApiModelProperty("设备量")
    private Integer deviceNum;
    @ApiModelProperty("项目量")
    private Integer projectNum;


    @ApiModelProperty("基本信")
    private String baseInfoType = LicenseChangeTypeEnum.CHANGE_UNIT_NAME.getType();
    @ApiModelProperty("场所")
    private String placeType =  LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getType();
    @ApiModelProperty("设备")
    private String deviceType  =  LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getType();
    @ApiModelProperty("项目")
    private String projectType  =  LicenseChangeTypeEnum.CHANGE_THERAPY_DEVICE_ADD.getType();



}
