package cn.smarthse.rho.modules.sys.model.b.vo.license;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 许可校验表列表
 * </p>
 *
 * @author chenliang
 * @since 2024-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChangeLicenseListVo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    //公司id
    private Long cid;

    //类型（LicenseChangeTypeEnum）
    private String type;

    //类型（LicenseChangeTypeEnum）
    private String subType;

    //标题
    private String title;

    //公司id 或者 设备id
    private Long targetId;

    //变更前值
    private String beforeValue;

    //变更后值
    private String afterValue;

    //变更前值
    private List<String> beforeValueList;

    //变更后值
    private List<String> afterValueList;

    //监管许可状态（0未许可 1已许可）
    private Integer adminLicenseStatus;

    //监管确认时间
    private LocalDateTime adminLicenseTime;

    //监管id
    private Long adminLicenseId;

    //许可生成时间
    private LocalDateTime genTime;



}
