package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * db_rho_external.company_bycd_expe同步
 * </p>
 *
 * @author chenliang
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ExternalCompanySyncVo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    private Long id;

    @ApiModelProperty(value = "同步时间（指的是wanda的同步时间，不是这条数据的更新时间）")
    private LocalDateTime syncTime;

    @ApiModelProperty(value = "来源id")
    private String sourceId;

    @ApiModelProperty("全国统一码")
    private String medicalNucode;

    @ApiModelProperty("是否是主院")
    private Integer isMain;

    @ApiModelProperty("主院id")
    private Long mainId;

    @ApiModelProperty("主院名称")
    private String mainName;

    @ApiModelProperty("所在医院id")
    private Long hospitalId;

    @ApiModelProperty("所在医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "医院名称")
    private String name;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "机构类型")
    private Integer type;

    @ApiModelProperty(value = "经济类型")
    private Integer economyCode;

    @ApiModelProperty(value = "医院等级")
    private Integer unitLevel;

    @ApiModelProperty(value = "经营性质")
    private Integer businessType;

    @ApiModelProperty(value = "营业状态")
    private Integer businessStatus;

    @ApiModelProperty(value = "院区状态（1-开启；0-关闭）")
    private Integer state;

    @ApiModelProperty(value = "床位数")
    private Integer floorNum;

    @ApiModelProperty(value = "工作地址行政区划")
    private Long areaId;

    @ApiModelProperty(value = "工作地址详情（eg：水墩新路88号）")
    private String address;

    @ApiModelProperty(value = "工作地址完整（eg：浙江省杭州市上城区笕桥街道水墩新路88号）")
    private String fullAddress;

    @ApiModelProperty(value = "注册地址完整")
    private String registeredFullAddress;

    @ApiModelProperty(value = "工作场所地址行政区划")
    private Long workAreaId;

    @ApiModelProperty(value = "工作场所地址详情")
    private String workAddress;

    @ApiModelProperty(value = "工作场所地址完整")
    private String workFullAddress;

    @ApiModelProperty(value = "法人代表姓名")
    private String legalName;

    @ApiModelProperty(value = "法人代表联系电话")
    private String legalTel;

    @ApiModelProperty(value = "主要负责人")
    private String mainLeaderName;

    @ApiModelProperty(value = "主要负责人手机号")
    private String mainLeaderTel;

    @ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属")
    private Integer belongType;

    @ApiModelProperty(value = "监督单位")
    private Long supervisionUnit;

    @ApiModelProperty(value = "监督单位区域")
    private Long supervisionAreaId;

    @ApiModelProperty("是否是测试")
    private Integer isTest;

    @ApiModelProperty(value = "是否需要创建账号")
    private Integer needAddAccount;


    @ApiModelProperty(value = "监管提供的地址")
    private String superviseFullAreaName;

}
