package cn.smarthse.rho.modules.sys.model.b.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 医院：同步信息vo
 * </p>
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CompanySyncFswsHospitalInfoVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("职卫云放射诊疗机构id（医院来源data_source是职卫云时必填）")
    private String zwyHospitalId;

    @ApiModelProperty("放射卫生在线放射诊疗机构id（医院来源data_source是放射卫生在线时必填）")
    private String rhoHospitalId;

    @ApiModelProperty("医院院区名称")
    private String name;

    @ApiModelProperty("医院统一社会信用代码（无则传18个0）")
    private String creditCode;

    @ApiModelProperty("营业状态（1-正常营业，2-暂停营业，0-关闭）")
    private String businessStatus;

    @ApiModelProperty("工作场所地址code（详见行政区划字典）")
    private String workAreaId;

    @ApiModelProperty("工作场所地址（eg：浙江省杭州市上城区xx街道xx路xx号）")
    private String workAddress;

    @ApiModelProperty("注册地址（eg：浙江省杭州市上城区xx街道xx路xx号）")
    private String registerAddress;

    @ApiModelProperty("数据新增方（标记本条数据由哪一方新增：1-放射卫生在线，2-职卫云）")
    private String dataCreateor;

    @ApiModelProperty("数据来源（标记医院数据由哪一方录入产生：1-放射卫生在线，2-职卫云）")
    private String dataSource;

    @ApiModelProperty("")
    private String optType;

    @ApiModelProperty("")
    private String oldSourceId;

    @ApiModelProperty("")
    private String optReason;

    @ApiModelProperty("")
    private LocalDateTime LoadTime;

    @ApiModelProperty("数据处理类别：0忽略 1正常数据处理 2异常数据处理")
    private Integer dataDealType;

    @ApiModelProperty("异常描述")
    private String errorDes;
    @ApiModelProperty("重复名称数量")
    private Integer duplicateNameNum;
    @ApiModelProperty("重复院区数量")
    private Integer duplicateNum;

}
