package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 医院：基础信息Vo
 * </p>
 *
 * @author chenliang
 * @since 2024-03-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BCompanyVo对象", description = "医院：基础信息")
public class BCompanyVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty("全国统一码")
    private String medicalNucode;

    @ApiModelProperty("是否是主院")
    private Integer isMain;

    @ApiModelProperty("主院id")
    private Long mainId;

    @ApiModelProperty("主院名称")
    private String mainName;

    @ApiModelProperty("所在医院id")
    private Long hospitalId;

    @ApiModelProperty("所在医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "医院名称")
    private String name;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "机构类型")
    private Integer type;

    @ApiModelProperty(value = "机构类型")
    private String typeName;

    @ApiModelProperty(value = "经济类型")
    private Integer economyCode;

    @ApiModelProperty(value = "经济类型")
    private String economyCodeName;

    @ApiModelProperty("医院等级（105）")
    private Integer unitLevel;

    @ApiModelProperty("医院等级（105）")
    private String unitLevelName;

    @ApiModelProperty("经营性质（106）")
    private Integer businessType;

    @ApiModelProperty("经营性质（106）")
    private String businessTypeName;

    @ApiModelProperty(value = "营业状态")
    private Integer businessStatus;

    @ApiModelProperty(value = "床位数")
    private Integer floorNum;

    @ApiModelProperty(value = "放射工作人员数")
    private Integer raEmployeeNum;

    @ApiModelProperty(value = "工作地址行政区划")
    private Long areaId;

    @ApiModelProperty(value = "工作地址详情（eg：水墩新路88号）")
    private String address;

    @ApiModelProperty(value = "工作地址完整（eg：浙江省杭州市上城区笕桥街道水墩新路88号）")
    private String fullAddress;

    @ApiModelProperty(value = "注册地址id")
    private Long registeredAreaId;

    @ApiModelProperty(value = "注册地址详情")
    private String registeredAddress;

    @ApiModelProperty(value = "注册地址完整")
    private String registeredFullAddress;

    @ApiModelProperty(value = "工作地址对象")
    private SysAreaVo workArea;

    @ApiModelProperty(value = "注册地址地址对象")
    private SysAreaVo registeredArea;
//    @ApiModelProperty(value = "工作场所地址行政区划")
//    private Long workAreaId;
//
//    @ApiModelProperty(value = "工作场所地址详情")
//    private String workAddress;
//
//    @ApiModelProperty(value = "工作场所地址完整")
//    private String workFullAddress;

    @ApiModelProperty(value = "法人代表姓名")
    private String legalName;

    @ApiModelProperty(value = "法人代表联系电话")
    private String legalTel;

    @ApiModelProperty(value = "主要负责人")
    private String mainLeaderName;

    @ApiModelProperty(value = "主要负责人手机号")
    private String mainLeaderTel;

    @ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属")
    @TableField("belong_type")
    private Integer belongType;

    @ApiModelProperty(value = "监督单位")
    private Long supervisionUnit;

    @ApiModelProperty(value = "监督单位区域")
    private Long supervisionAreaId;

    @ApiModelProperty("是否是测试")
    private Integer isTest;

    @ApiModelProperty(value = "放射卫管理人员")
    private String raManagerName;

    @ApiModelProperty(value = "放射卫管理人员手机号")
    private String raManagerTel;

}
