package cn.smarthse.rho.modules.sys.model.b.param.hse.training;

import cn.smarthse.core.framework.model.LayuiGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = false)
@Data
public class RhoCompanyUserPageParam extends LayuiGridParam {
    @ApiModelProperty("关键字")
    private String keyword;

    private Long loginUserId;
    private Long userAreaId;
    private Integer userAreaLevel;
//    private Integer isOnlineSpecialTestUser;


    @ApiModelProperty(value = "行政区划id")
    private Long areaId;

    @ApiModelProperty(value = "行政区划level", hidden = true)
    private Integer level;

    @ApiModelProperty(value = "营业状态（1-正常 2-暂停营业 0-关闭）")
    private Integer businessState;

    @ApiModelProperty(value = "账号状态 1：可用 2：禁用 3：无账号")
    private Integer accountStatus;

    @ApiModelProperty(value = "是否是本账号创建（0否 1是）")
    private Integer isNowUser;

    @ApiModelProperty(value = "是否是测试企业（0否 1是）")
    private Integer isTest;

    @ApiModelProperty(value = "来源(0放射卫生 5培训)")
    private Integer virtuallyDataSource;



}
