package cn.smarthse.rho.modules.sys.model.b.param;

import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.PageParam;
import cn.smarthse.rho.modules.sys.enums.staff.CmSourceEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 医院：同步信息
 * </p>
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CompanySyncParam extends PageParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer wandaSource = CmSourceEnum.WAND.getValue();

    @ApiModelProperty("医院全国唯一码")
    private List<String> medicalNucodeList;

    @ApiModelProperty("医院全国唯一社会信用代码")
    private List<String> creditCodeList;

    @ApiModelProperty("医院全国唯一码")
    private String medicalNucode;

    @ApiModelProperty("加载时间")
    private LocalDateTime loadTime;
}
