package cn.smarthse.rho.modules.sys.model.b.param;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 单位：信息修改记录
 * </p>
 *
 * @author chenliang
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="单位：信息修改记录", description="单位：信息修改记录")
public class CompanyInfoChangeLogParam extends PageParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "修改字段")
    private String fieldValues;

    @ApiModelProperty(value = "修改字段")
    private List<String> fieldValuesList;


    public List<String> getFieldValuesList() {
        if(CollUtil.isNotEmpty(fieldValuesList)){
            return fieldValuesList;
        }else {
            if(StrUtil.isNotEmpty(fieldValues)){
                return StrUtil.split(fieldValues,",");
            }else {
                return fieldValuesList;
            }
        }
    }
}
