package cn.smarthse.rho.modules.sys.model.b.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 放射防护管理领导小组
 * </p>
 *
 * @author chenliang
 * @since 2024-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="BRayManage编辑参数", description="放射防护管理领导小组编辑参数")
public class BRayManageEditParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "单位id")
    private Long cid;

    @ApiModelProperty(value = "领导机构名称")
    private String name;

//    @ApiModelProperty(value = "放射卫生防护管理人员id")
//    private Long staffId;
//
//    @ApiModelProperty(value = "放射卫生防护管理人员")
//    private String staffName;

    @ApiModelProperty(value = "负责人联系电话")
    private String tel;

    @ApiModelProperty(value = "成立文件")
    private String file;

    @ApiModelProperty(value = "日程管理部门ids")
    private String orgIds;

    @ApiModelProperty(value = "日程管理部门名称")
    private String orgNames;

    @ApiModelProperty(value = "编辑时间")
    private LocalDateTime editTime;

}
