package cn.smarthse.rho.modules.sys.model.b.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 医院：基础信息编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-03-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="编辑参数", description="医院：基础信息")
public class BCompanyInfoParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司id")
    private Long cid;

    @ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）", hidden = true)
    private Integer type;


}
