package cn.smarthse.rho.modules.sys.model.b.param;

import cn.smarthse.core.framework.model.UserEditParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 医院：基础信息编辑参数
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="编辑参数", description="医院：基础信息")
public class BCompanyAdminEditParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "机构名称")
    private String hospitalName;

    @ApiModelProperty(value = "院区名称")
    private String name;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "全国唯一标识码")
    private String medicalNucode;

    @ApiModelProperty(value = "工作地址行政区划")
    private Long areaId;

    @ApiModelProperty(value = "工作地址详情（eg：水墩新路88号）")
    private String address;

    @ApiModelProperty(value = "注册地址id")
    private Long registeredAreaId;

    @ApiModelProperty(value = "注册地址详情")
    private String registeredAddress;

    @ApiModelProperty(value = "法人代表姓名")
    private String legalName;

    @ApiModelProperty(value = "法人代表联系电话")
    private String legalTel;

    @ApiModelProperty(value = "主要负责人")
    private String mainLeaderName;

    @ApiModelProperty(value = "主要负责人手机号")
    private String mainLeaderTel;

    @ApiModelProperty(value = "管理人员负责人")
    private String managerName;

    @ApiModelProperty(value = "管理人员人手机号")
    private String managerTel;

    @ApiModelProperty(value = "监督单位id")
    private Long supervisionUnit;

    @ApiModelProperty(value = "监督单位区域id")
    private Long supervisionAreaId;
}
