package cn.smarthse.rho.modules.sys.enums.wanda;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 异常数据退回记录-数据异常类型枚举类 （具体待数据对接实际情况确定）
 * 0-必填字段值缺失或格式有误;
 * 1-医院信用代码和医院名称不匹配;
 * 2-医院不存在放射卫生在线;
 * 3-无体检结论;
 * 4-无体检危害因素;
 * 5-无体检结论且无体检危害因素;
 *
 * @author wuxq
 * @since 2024/12/11
 */
@Getter
@AllArgsConstructor
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FswsErrorDataErrTypeEnum {

    FORMAT_ERROR(0, "数据格式错误", "0,"),

    /**
     * 医院信用代码和医院名称不匹配;
     * 医院不存在放射卫生在线;
     * 无体检结论;
     * 无体检危害因素;
     * 无体检结论且无体检危害因素;
     * ``````
     */
    EXCEPTION_ERROR(1, "数据异常", "1,"),
    ;

    private final int code;
    private final String name;
    private final String codeStr;

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (FswsErrorDataErrTypeEnum c : FswsErrorDataErrTypeEnum.values()) {
            if (c.getCode() == code) {
                return c.name;
            }
        }
        return null;
    }

}
