package cn.smarthse.rho.modules.sys.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训人员证书-类型
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum TrainingCertTypeEnum {

    TYPE_1("放射卫生防护管理人员培训证", 1),
    TYPE_2("放射工作人员防护培训合格证", 2),

    ;

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        TrainingCertTypeEnum[] values = TrainingCertTypeEnum.values();
        for (TrainingCertTypeEnum certTypeEnum : values) {
            if (certTypeEnum.getValue().equals(value)) {
                return certTypeEnum.getName();
            }
        }
        return "";
    }

}
