package cn.smarthse.rho.modules.sys.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训人员证书-审核状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum TrainingCertSourceEnum {

    TRAINING("培训同步", 1),
    UNIT("单位添加", 2);

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        TrainingCertSourceEnum[] values = TrainingCertSourceEnum.values();
        for (TrainingCertSourceEnum trainingCertSourceEnum : values) {
            if (trainingCertSourceEnum.getValue().equals(value)) {
                return trainingCertSourceEnum.getName();
            }
        }
        return "";
    }

}
