package cn.smarthse.rho.modules.sys.enums.train;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 培训人员证书-审核状态
 *
 * @author wuxq
 * @since 2023/5/5 9:49
 */
@AllArgsConstructor
@Getter
public enum TrainingCertAuditStatusEnum {

    DRAFT("草稿", 0),
    PASSED("已通过", 1),
    REFUND("被退回", 2),
    WAIT_AUDIT("待审核", 3),
    NO_AUDIT("无需审核", 4),
    TERMINATED("已终止", 5);

    private final String name;
    private final Integer value;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        TrainingCertAuditStatusEnum[] values = TrainingCertAuditStatusEnum.values();
        for (TrainingCertAuditStatusEnum certificateStaffDetailDataSourceEnum : values) {
            if (certificateStaffDetailDataSourceEnum.getValue().equals(value)) {
                return certificateStaffDetailDataSourceEnum.getName();
            }
        }
        return "";
    }

}
