package cn.smarthse.rho.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SysChangeLogEnum {

    // b_company
    company_is_main(1001, "b_company", "is_main", "是否是主院变更"),
    company_hospital_name(1002, "b_company", "hospital_name", "放射诊疗机构名称变更"),
    company_name(1003, "b_company", "name", "附属对象(院区)名称变更"),
    company_credit_code(1004, "b_company", "credit_code", "统一社会信用代码变更"),
    company_business_status(1005, "b_company", "business_status", "营业状态变更"),
    company_area_id(1006, "b_company", "area_id", "行政区划变更"),
    company_state(1007, "b_company", "state", "院区状态变更"),
    company_legal_name(1008, "b_company", "legal_name", "法人代表姓名变更"),
    company_legal_tel(1009, "b_company", "legal_tel", "法人代表联系电话变更"),
    company_main_leader_name(1010, "b_company", "main_leader_name", "主要负责人变更"),
    company_main_leader_tel(1011, "b_company", "main_leader_tel", "主要负责人联系电话变更"),
    company_belong_type(1012, "b_company", "belong_type", "直属类型变更"),
    company_supervision_unit(1013, "b_company", "supervision_unit", "监督单位变更"),
    company_medical_nucode(1014, "b_company", "medical_nucode", "唯一编码变更"),

    // c_staff_base_info
    c_staff_base_info_name(2001, "c_staff_base_info", "name", "姓名变更"),
    c_staff_base_info_phone(2002, "c_staff_base_info", "phone", "手机号变更"),


    // c_staff
    c_staff_base_id(3001, "c_staff", "post", "人员基础信息id变更"),
    c_staff_cid(3002, "c_staff", "cid", "单位id变更"),


    // sys_user
    sys_user_username(4001, "sys_user", "username", "账号名称变更"),
    ;

    private final Integer key;
    private final String tableName;
    private final String column;
    private final String value;

    public static String getValueByKey(Integer key) {
        if (key == null) {
            return null;
        }
        for (SysChangeLogEnum remind : SysChangeLogEnum.values()) {
            if (Objects.equals(key, remind.getKey())) {
                return remind.getValue();
            }
        }
        return null;
    }

    public static SysChangeLogEnum[] getByTableName(String tableName) {

        return Arrays.stream(SysChangeLogEnum.values())
                .filter(c -> tableName.equals(c.getTableName()))
                .toArray(SysChangeLogEnum[]::new);
    }

}
