package cn.smarthse.rho.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@Getter
@AllArgsConstructor
public enum RhoUserRolesEnum {

    RHO_COMPANY_SUPER_ADMIN(1L, "超级管理员"),//5000L
    RHO_COMPANY_COMMON_USER(2L, "普通用户"),//5001L
    RHO_COMPANY_SIGN_ON_SINGLE(100L, "单点登录用户（兼容旧数据）待用户表数据清洗后删除"),//5002L
    ;

    private final Long roleId;
    private final String roleName;

    public static RhoUserRolesEnum getByValue(Long roleId) {
        for (RhoUserRolesEnum userRole : RhoUserRolesEnum.values()) {
            if (userRole.getRoleId().equals(roleId)) {
                return userRole;
            }
        }
        return null;
    }

}
