package cn.smarthse.rho.modules.sys.enums.staff;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 医院等级
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum StaffCertTypeEnum {

	TYPE1("放射卫生防护管理人员培训证",1),
	TYPE2("放射工作人员防护培训合格证",2),
	;

	/**成员变量*/
	private final String name;
	private final Integer value;

	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (StaffCertTypeEnum c : StaffCertTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}







}
