package cn.smarthse.rho.modules.sys.enums.staff;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 医院等级
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PostStatusEnum {
	NON_POST("离岗",0),
	ON_POST("在岗",1),
	TP_NON_POST("暂离",2),

	;

	/**成员变量*/
	private String name;
	private Integer value;

	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (PostStatusEnum c : PostStatusEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}



}
