package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险类型枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskTypeEnum {

	/**
	 *	许可管理
	 */
	LICENSE_MANAGEMENT("许可管理",101),

	/**
	 *	性能检测
	 */
	PERFORMANCE_TEST("性能检测", 102),

	/**
	 *	场所检测
	 */
	PLACE_TEST("场所检测", 103),

	/**
	 *	职业健康体检
	 */
	PHYSICAL_EXAMINATION("职业健康体检", 104),

	/**
	 *	个人剂量监测
	 */
	DOSE_MONITORING("个人剂量监测", 105),

	/**
	 *	放射工作人员 培训
	 */
	TRAINING("放射工作人员培训", 106),

	/**
	 *	三同时
	 */
	THREE("建设项目“三同时”", 107),

	/**
	 * 个人防护用品
	 */
	PERSONAL_PROTECTIVE_EQUIPMENT("个人防护用品",108),

	/**
	 * 安全装置和警示标识
	 */
	SAFETY_DEVICES_AND_ALERTS("安全装置和警示标识",109)

	;

	private String name;
	private Integer value;

	public static String getName(Integer value) {
		for (RiskTypeEnum c : RiskTypeEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return "";
	}
}
