package cn.smarthse.rho.modules.sys.enums.risk;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import javax.persistence.TemporalType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

/**
 * 风险期限枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskEffectiveEnum {

	PHYSICAL_EXAMINATION("健康体检", 2, 1),
	TRAINING("培训", 2, 1),
	DOSE("个人剂量", 3, 2),

	;

	private String name;
	//时间间隔
	private Integer value;
	//1year 2month
 	private Integer type;

	public static String getName(Integer value) {
		for (RiskEffectiveEnum c : RiskEffectiveEnum.values()) {
			if (c.getValue().equals(value)) {
				return c.getName();
			}
		}
		return "";
	}

}
