package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 风险验收记录结论枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RiskAcceptanceResultEnum {

    NOT_PASS("不通过", 0),

    PASSED("通过", 1),

    ;

    private final String name;
    private final Integer value;

    public static String getName(Integer value) {
        for (RiskAcceptanceResultEnum c : RiskAcceptanceResultEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
