package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 自检承诺书：关键因素画像类型枚举
 *
 * @Author czq
 * @Creat 2025-06-26 08:55
 **/
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum KeyFactorTypeEnum {

    PPE_SELF_CHECK(1, "个人防护用品自检"),     // 个人防护用品自检
    SD_SELF_CHECK(2, "安全装置和警示标识自检");  // 安全装置和警示标识自检

    private final Integer code;
    private final String name;

    public static String getName(Integer value) {
        for (KeyFactorTypeEnum c : KeyFactorTypeEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
