package cn.smarthse.rho.modules.sys.enums.risk;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @ author Supw
 * @ since 2023/5/6 14:03
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum KeyFactoAuditStatusEnum {

    DRAFT(0,"草稿"),
    PASS(1,"已通过"),
    BACK(2,"被退回"),
    AUDIT(3,"待审核"),
    NOT_NEED_AUDIT(4,"无须审核"),
    CLOSED(5,"已终止"),
    ;

    private final Integer code;
    private final String name;

    public static String getName(Integer value) {
        for (KeyFactoAuditStatusEnum c : KeyFactoAuditStatusEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.getName();
            }
        }
        return "";
    }
}
