package cn.smarthse.rho.modules.sys.enums.license;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 许可管理类型（a_license.sub_type）
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LicenseChangeTypeEnum {
	// 0000 0000 0000
	//第一个4位数：表示什么大类型：基础信息、设备
	//第二个4位数：表示什么子类型：单位名变更、单位地址变更、设备新增 等等
	//第三个4位数：预留
	CHANGE_UNIT_NAME				("单位名变更"		,"基础信息","1001","100100010000"),
	CHANGE_UNIT_ADDRESS				("单位地址变更"	,"基础信息","1001","100100020000"),
	CHANGE_UNIT_LEGAL				("法定代表人"		,"基础信息","1001","100100030000"),
	CHANGE_UNIT_LEADER				("主要负责人"		,"基础信息","1001","100100040000"),



	CHANGE_THERAPY_DEVICE_ADD		("设备新增","设备","1002","100200010000"),
	CHANGE_THERAPY_DEVICE_SUB		("设备注销","设备","1002","100200020000"),
	CHANGE_THERAPY_DEVICE_PLACE		("场所变更","设备","1002","100200030000"),
	CHANGE_THERAPY_DEVICE_PROJECT	("项目变更","设备","1002","100200040000"),
	;

	private String name;
	private String category;
	private String type;
	private String subType;


	public static LicenseChangeTypeEnum getEnumBySubType(String subType) {
		if(StrUtil.isBlank(subType)){
			return null;
		}
		for (LicenseChangeTypeEnum value : values()) {
			if(value.subType.equals(subType)){
				return value;
			}
		}
		return null;
	}
}
