package cn.smarthse.rho.modules.sys.enums.license;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 许可管理 变更校验类型（b_cert_change_log.type）
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CertChangeLogTypeEnum {

    TYPE_1(1, "新发"),
    TYPE_2(2, "变更"),
    TYPE_3(3, "校验"),
    TYPE_4(4, "注销"),
    ;

    private final Integer code;
    private final String name;

    public static String getName(Integer code) {

        if (code == null) {
            return "";
        }
        for (CertChangeLogTypeEnum c : CertChangeLogTypeEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return "";
    }

}
