package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 已许可状态类型(1-正常；2-校验即将到期；3-校验已过期)
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum EdeviceLicenseStatusTypeEnum {

	NONE(0,"无"),
	NORMAL(1,"正常"),
	DUE_SOON(2,"校验即将到期"),
	OVER_DUE(3,"校验已过期"),
	;

	private Integer value;
	private String name;

}
