package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 许可证状态(0-无；1-未许可；2-已许可)
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum EdeviceLicenseStatusEnum {

    NONE(0, "无"),
    UNAUTHORIZED(1, "未许可"),
    AUTHORIZED(2, "已许可"),
    ;

    private Integer value;
    private String name;


    public static String getNameByValue(Integer value) {
        if (value == null) {
            return "";
        }
        EdeviceLicenseStatusEnum[] values = EdeviceLicenseStatusEnum.values();
        for (EdeviceLicenseStatusEnum statusEnum : values) {
            if (statusEnum.getValue().equals(value)) {
                return statusEnum.getName();
            }
        }
        return "";
    }

}
