package cn.smarthse.rho.modules.sys.enums.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 放射诊疗类别
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum EdeviceDiagnosisTypeEnum {


	/**
	 *	10 - X射线影像诊断
	 */
	XRAY(10,"X射线影像诊断"),
		/**
		 *	11 - X射线影像诊断-X射线CT影像诊断
		 */
		XRAY_CT(11,"X射线影像诊断-X射线CT影像诊断"),
		/**
		 *	12 - X射线影像诊断-CR、DR影像诊断
		 */
		XRAY_CRDR(12,"X射线影像诊断-CR、DR影像诊断"),
		/**
		 *	13 - X射线影像诊断-牙科X射线影像诊断
		 */
		XRAY_DENTISTRY(13,"X射线影像诊断-牙科X射线影像诊断"),
		/**
		 *	14 - X射线影像诊断-乳腺X射线影像诊断
		 */
		XRAY_BREAST(14,"X射线影像诊断-乳腺X射线影像诊断"),
		/**
		 *	15 - X射线影像诊断-普通X射线机影像诊断
		 */
		XRAY_ORDINARY(15,"X射线影像诊断-普通X射线机影像诊断"),
		/**
		 *	16 - X射线影像诊断-其他X射线影像诊断
		 */
		XRAY_OTHER(16,"X射线影像诊断-其他X射线影像诊断"),

	/**
	 *	20 - 介入放射学
	 */
	INTERVENTIONAL(20,"介入放射学"),
		/**
		 *	21 - 介入放射学-DSA介入放射诊疗
		 */
		INTERVENTIONAL_DSA(21,"介入放射学-DSA介入放射诊疗"),
		/**
		 *	22 - 介入放射学-其他影像设备介入放射诊疗
		 */
		INTERVENTIONAL_OTHER(22,"介入放射学-其他影像设备介入放射诊疗"),

	/**
	 *	30 - 核医学
	 */
	NUCLEAR(30,"核医学"),
		/**
		 *	31 - 核医学-PET影像诊断
		 */
		NUCLEAR_PET(31,"核医学-PET影像诊断"),
		/**
		 *	32 - 核医学-SPECT影像诊断
		 */
		NUCLEAR_SPECT(32,"核医学-SPECT影像诊断"),
		/**
		 *	33 - 核医学-γ相机影像诊断
		 */
		NUCLEAR_Y(33,"核医学-γ相机影像诊断"),
		/**
		 *	34 - 核医学-骨密度测量（γ射线）
		 */
		NUCLEAR_BONE(34,"核医学-骨密度测量（γ射线）"),
		/**
		 *	35 - 核医学-籽粒插植治疗
		 */
		NUCLEAR_SEED(35,"核医学-籽粒插植治疗"),
		/**
		 *	36 - 核医学-放射性药物治疗
		 */
		NUCLEAR_RADIOPHARMACEUTICAL(36,"核医学-放射性药物治疗"),
		/**
		 *	37 - 核医学-其他核医学诊疗项目
		 */
		NUCLEAR_OTHER(37,"核医学-其他核医学诊疗项目"),

	/**
	 *	40 - 放射治疗
	 */
	RADIATION_THERAPY(40,"放射治疗"),
		/**
		 *	41 - 放射治疗-立体定向（γ刀、X刀）治疗
		 */
		RADIATION_THERAPY_YX(41,"放射治疗-立体定向（γ刀、X刀）治疗"),
		/**
		 *	42 - 放射治疗-医用加速器治疗
		 */
		RADIATION_THERAPY_MEDICAL(42,"放射治疗-医用加速器治疗"),
		/**
		 *	43 - 放射治疗-质子等重粒子治疗
		 */
		RADIATION_THERAPY_PROTON(43,"放射治疗-质子等重粒子治疗"),
		/**
		 *	44 - 放射治疗-钴60机治疗
		 */
		RADIATION_THERAPY_COBALT(44,"放射治疗-钴-60机治疗"),
		/**
		 *	45 - 放射治疗-后装治疗
		 */
		RADIATION_THERAPY_AFTERLOADING(45,"放射治疗-后装治疗"),
		/**
		 *	46 - 放射治疗-深部X射线机治疗
		 */
		RADIATION_THERAPY_DEEPX(46,"放射治疗-深部X射线机治疗"),
		/**
		 *	47 - 放射治疗-敷贴治疗
		 */
		RADIATION_THERAPY_APPLICATION(47,"放射治疗-敷贴治疗"),
		/**
		 *	48 - 放射治疗-其他放射治疗项目
		 */
		RADIATION_THERAPY_OTHER(48,"放射治疗-其他放射治疗项目"),
	;


	private Integer value;
	private String name;


	public static String getName(Integer value) {

		if (value == null) {
			return null;
		}
		for (EdeviceDiagnosisTypeEnum c : EdeviceDiagnosisTypeEnum.values()) {
			if (c.getValue().equals(Integer.valueOf(value))) {
				return c.name;
			}
		}
		return null;
	}

	public static Integer getCodeByName(String name) {
		if(StrUtil.isBlank(name)){
			return null;
		}

		for (EdeviceDiagnosisTypeEnum c : EdeviceDiagnosisTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return null;
	}

	public static String getCodesByNames(String names, String split) {
		if (StringUtils.isNotEmpty(names)) {
			List<String> nameList = Pattern.compile(",").splitAsStream(names).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(nameList)) {
				List<String> resultList = new ArrayList<>();
				nameList.forEach(name -> {
					Integer result = getCodeByName(name);
					if(result != null){
						resultList.add(String.valueOf(result));
					}
				});
				return CollUtil.isEmpty(resultList) ? null : org.apache.commons.lang3.StringUtils.join(resultList, split);
			}
		}
		return null;
	}

	public static String getNamesByCodes(String codes) {

		if (StringUtils.isNotEmpty(codes)) {
			List<Integer> codeList = Pattern.compile(",").splitAsStream(codes).filter(v->StrUtil.isNumeric(v)).map(v->Integer.valueOf(v)).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(codeList)) {
				List<String> nameList = new ArrayList<>();
				codeList.forEach(value -> {
					nameList.add(getName(value));
				});
				return org.apache.commons.lang3.StringUtils.join(nameList, "、");
			}
		}
		return "";
	}

	public static String getNamesByCodes(String codes, String split) {

		if (StringUtils.isNotEmpty(codes)) {
			List<Integer> codeList = Pattern.compile(",").splitAsStream(codes).filter(v->StrUtil.isNumeric(v)).map(v->Integer.valueOf(v)).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(codeList)) {
				List<String> nameList = new ArrayList<>();
				codeList.forEach(value -> {
					nameList.add(getName(value));
				});
				return org.apache.commons.lang3.StringUtils.join(nameList, split);
			}
		}
		return "";
	}


	public static String getXrayNamesByCodes(String codes, String split) {

		if (StringUtils.isNotEmpty(codes)) {
			List<Integer> codeList = Pattern.compile(",").splitAsStream(codes).filter(v->StrUtil.isNumeric(v)).map(v->Integer.valueOf(v)).filter(v->isXRAY(v)).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(codeList)) {
				List<String> nameList = new ArrayList<>();
				codeList.forEach(value -> {
					nameList.add(getName(value));
				});
				return org.apache.commons.lang3.StringUtils.join(nameList, split);
			}
		}
		return "";
	}

	public static String getInterventionalNamesByCodes(String codes, String split) {

		if (StringUtils.isNotEmpty(codes)) {
			List<Integer> codeList = Pattern.compile(",").splitAsStream(codes).filter(v->StrUtil.isNumeric(v)).map(v->Integer.valueOf(v)).filter(v->isINTERVENTIONAL(v)).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(codeList)) {
				List<String> nameList = new ArrayList<>();
				codeList.forEach(value -> {
					nameList.add(getName(value));
				});
				return org.apache.commons.lang3.StringUtils.join(nameList, split);
			}
		}
		return "";
	}

	public static String getNuclearNamesByCodes(String codes, String split) {

		if (StringUtils.isNotEmpty(codes)) {
			List<Integer> codeList = Pattern.compile(",").splitAsStream(codes).filter(v->StrUtil.isNumeric(v)).map(v->Integer.valueOf(v)).filter(v->isNUCLEAR(v)).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(codeList)) {
				List<String> nameList = new ArrayList<>();
				codeList.forEach(value -> {
					nameList.add(getName(value));
				});
				return org.apache.commons.lang3.StringUtils.join(nameList, split);
			}
		}
		return "";
	}

	public static String getRadiationNamesByCodes(String codes, String split) {

		if (StringUtils.isNotEmpty(codes)) {
			List<Integer> codeList = Pattern.compile(",").splitAsStream(codes).filter(v->StrUtil.isNumeric(v)).map(v->Integer.valueOf(v)).filter(v->isRADIATION_THERAPY(v)).collect(Collectors.toList());
			if (!CollectionUtils.isEmpty(codeList)) {
				List<String> nameList = new ArrayList<>();
				codeList.forEach(value -> {
					nameList.add(getName(value));
				});
				return org.apache.commons.lang3.StringUtils.join(nameList, split);
			}
		}
		return "";
	}


	public static boolean isXRAY(Integer value){
		return value >= 10 && value < 20;
	}
	public static boolean isINTERVENTIONAL(Integer value){
		return value >= 20 && value < 30;
	}
	public static boolean isNUCLEAR(Integer value){
		return value >= 30 && value < 40;
	}
	public static boolean isRADIATION_THERAPY(Integer value){
		return value >= 40 && value < 50;
	}

}
