package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 附属对象(院区)状态
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CompanyStateEnum {

    OPEN(1, "开启"),
    SHUTDOWN(0, "关闭"),
    ;

    private final Integer value;
    private final String name;

    public static String getNameByValue(Integer value) {
        if (value == null) {
            return null;
        }
        for (CompanyStateEnum remind : CompanyStateEnum.values()) {
            if (Objects.equals(value, remind.getValue())) {
                return remind.getName();
            }
        }
        return null;
    }

}
