package cn.smarthse.rho.modules.sys.enums.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 诊疗许可证校验周期枚举
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum CompanyCertCycleEnum {
	ZHYY	("103011","一",1,3,"综合医院"),
	ZYYY	("103012","一",3,3,"中医医院"),
	ZXYJHYY	("103013","一",3,3,"中西医结合医院"),
	MZYYY	("103014","一",3,3,"民族医医院"),
	ZKYY	("103015","一",3,3,"专科医院"),
	KFYY	("103016","一",3,3,"康复医院"),
	FYBJY	("103021","二",3,3,"妇幼保健院"),
	SQWSFWZX("103031","三",1,1,"社区卫生服务中心"),
	SQWSFWZ	("103032","三",1,1,"社区卫生服务站"),
	ZXWSY	("103033","三",1,1,"中心卫生院"),
	XZWSY	("103042","四",1,1,"乡(镇)卫生院"),
	JDWSY	("103043","四",1,1,"街道卫生院"),
	YLY		("103051","五",3,3,"疗养院"),
	ZHMZB	("103061","六",1,1,"综合门诊部"),
	ZKMZB	("103062","六",1,1,"专科门诊部"),
	ZYMZB	("103063","六",1,1,"中医门诊部"),
	ZXYJHMZB("103064","六",1,1,"中西医结合门诊部"),
	MZYMZB	("103065","六",1,1,"民族医门诊部"),
	ZS		("103071","七",1,1,"诊所"),
	ZYZS	("103072","七",1,1,"中医诊所"),
	MZYZS	("103073","七",1,1,"民族医诊所"),
	WSY		("103074","七",1,1,"卫生所"),
	YWS		("103075","七",1,1,"医务所"),
	YWS2	("103076","七",1,1,"医务室"),
	WSBJS	("103077","七",1,1,"卫生保健所"),
	WSZ		("103078","七",1,1,"卫生站"),
	CWSSS	("103081","八",1,1,"村卫生室(所)"),
	JJZX	("103091","九",3,3,"急救中心"),
	JJZ		("103092","九",1,1,"急救站"),
	LCJYZX	("103101","十",3,3,"临床检验中心");
	//sys_param表code
	private String code;
	//类型
	private String type;
	//床位数小于等于100的年份的周期
	private Integer lte100Cycle;
	//床位数大于100的年份的周期
	private Integer gt100Cycle;
	//医院名称
	private String name;


	public static Integer getCycle(String code, Integer floorNum){
		for (CompanyCertCycleEnum enumSub :CompanyCertCycleEnum.values()){
			if(enumSub.getCode().equals(code)){
				if(floorNum == null || floorNum<=100){
					return enumSub.getLte100Cycle();
				}else{
					return enumSub.getGt100Cycle();
				}
			}
		}
		return null;
	}


}
